(function(yr) {
    function pluck(list, popertyName) {
        var result = [];

        for (var i = 0, c = list.length; i < c; i++) {
            var item = list[i];
            var value = item && item[popertyName];

            if (value) {
                result.push(value);
            }
        }

        return result;
    }

    function extendHelper(deep, destination, source) {
        for (var prop in source) {
            var sp = source[prop];
            var dp = destination[prop];

            if (deep && destination === sp) {
                continue;
            }

            if (deep && typeof sp === 'object' && dp) {
                extendHelper(deep, dp, sp);
            } else if (sp !== undefined) {
                destination[prop] = source[prop];
            }
        }

        return destination;
    }

    function extend(deep) {
        var exts = Array.prototype.slice.call(arguments, 1);
        var newObj = {};

        for (var i = 0, c = exts.length; i < c; i++) {
            var ext = exts[i];

            extendHelper(deep, newObj, ext);
        }

        return newObj;
    }

    yr.externals['entityify'] = function(str) {
        var entityMap = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#39;',
            '/': '&#x2F;'
        };

        // eslint-disable-next-line no-useless-escape
        return String(str).replace(/[&<>"'\/]/g, function(s) {
            return entityMap[s];
        });
    };

    yr.externals['firstletter'] = function(str) {
        return str.charAt(0);
    };

    yr.externals['allbutfirstletter'] = function(str) {
        return str.substr(1);
    };

    yr.externals['capitalize'] = function(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    };

    yr.externals['random'] = function() {
        return parseInt(Math.random() * 100000, 10);
    };

    yr.externals['getfullyear'] = function() {
        return new Date().getFullYear();
    };

    /**
     * Конвертация yate-объекта в строку
     * @param {Object} obj
     * @returns {string}
     */
    yr.externals['stringify'] = function(obj) {
        if (obj.length && obj.length > 0) {
            obj = obj[0];
        }

        return (obj.data && JSON.stringify(obj.data)) || '{}';
    };

    /**
     * @param {string} str
     * @param {string|number} key
     * @param {string|number} val
     * @returns {string}
     */
    yr.externals['replace'] = function(str, key, val) {
        return str.replace(key, val);
    };

    /**
     * @param {array} array
     * @param {string|number} val
     * @returns {array}
     */
    yr.externals['selectoption'] = function(array, val) {
        var arr = array[0].data.items;

        arr.forEach(function(item) {
            if (item.value === val) {
                item.selected = true;
            }
        });

        return arr;
    };

    /**
     * @param {array} array
     * @param {string|number} val
     * @returns {array}
     */
    yr.externals['userquestions'] = function(array, val) {
        var result = [];

        array.forEach(function(item) {
            var opt = {
                value: item.data.id,
                text: item.data.value || item.data.text
            };

            if (val && item.data.id === val) {
                opt.selected = true;
            }

            result.push(opt);
        });

        return result;
    };

    yr.externals['match'] = function(str, key) {
        if (!str || typeof str !== 'string') {
            return false;
        }

        return str.match(key);
    };

    yr.externals['_nb-wrap'] = function(name, options) {
        var data = {};

        if (options && options.length) {
            data[name] = options.length === 1 ? options[0].data : pluck(options, 'data');
        }

        return [
            {
                data: data,
                name: '',
                parent: null,
                doc: options[0].doc
            }
        ];
    };

    yr.externals['_nb-extend'] = function(parent, node) {
        if (node && node[0]) {
            if (typeof node === 'string') {
                parent[0].data.content = node;
            } else {
                var dataParent = parent[0].data;
                var dataNode = node[0].data;
                var dataNew = extend(false, dataParent, dataNode);

                parent[0].data = dataNew;
            }
        }

        return parent;
    };

    yr.externals['_nb-deep-extend'] = function(parent, node) {
        if (node && node[0]) {
            if (typeof node === 'string') {
                parent[0].data.content = node;
            } else {
                var dataParent = parent[0].data;
                var dataNode = node[0].data;
                var dataNew = extend(true, dataParent, dataNode);

                parent[0].data = dataNew;
            }
        }

        return parent;
    };

    yr.externals['_nb-uniq'] = (function() {
        var uniq = 0;

        return function() {
            return uniq++;
        };
    })();

    yr.externals['_nb-warn'] = function(message) {
        // eslint-disable-next-line no-console
        console.log('%c' + message, 'color:#ffcc00');
    };

    yr.externals['extend'] = yr.externals['_nb-extend'];
    yr.externals['wrap'] = yr.externals['_nb-wrap'];

    yr.externals['i18n-plural'] = function(lang, count, one, some, many) {
        return i18n['tanker']['dynamic']['plural_adv']({
            count: count,
            one: one,
            some: some,
            many: many
        });
    };

    yr.externals['spellMonthGen'] = function(lang, month) {
        var monthes = {
            0: i18n('%time.month.gen.0'),
            1: i18n('%time.month.gen.1'),
            2: i18n('%time.month.gen.2'),
            3: i18n('%time.month.gen.3'),
            4: i18n('%time.month.gen.4'),
            5: i18n('%time.month.gen.5'),
            6: i18n('%time.month.gen.6'),
            7: i18n('%time.month.gen.7'),
            8: i18n('%time.month.gen.8'),
            9: i18n('%time.month.gen.9'),
            10: i18n('%time.month.gen.10'),
            11: i18n('%time.month.gen.11')
        };

        if (typeof month !== 'number') {
            month = parseInt(month, 10);
        }
        return monthes[month - 1];
    };

    yr.externals['includes'] = function(list, str) {
        return list.indexOf(str) !== -1;
    };
})(yr);
