/* eslint-env node */

var tankerDinamic = {};

['ru', 'en', 'tr', 'uk', 'az', 'fi', 'fr', 'id', 'kk', 'uz'].forEach(function(lang) {
    tankerDinamic[lang] = require('vm').runInNewContext(
        require('fs').readFileSync('./lib/tanker/tanker.dynamic.' + lang + '.js', 'utf-8')
    );
});

/**
 * Adds externals to yate run
 * @param {Object} yr               Yate Run
 * @param {Object} yr.externals     Object holding external methods
 */
module.exports = function(yr) {
    var logger = new (require('plog'))(null, 'passport', 'yate', 'externals');

    //Подгрузка экстерналов наноостровов
    require('vm').runInNewContext(require('fs').readFileSync('./plibs/nanoislands/externals.yate.js', 'utf-8'), {
        yr: yr
    });
    //Подгрузка общих для клиента и сервера экстерналов
    require('vm').runInNewContext(require('fs').readFileSync(__dirname + '/externals.js', 'utf-8'), {yr: yr});

    require('pheader/header.yate.externals.js')(yr);

    yr.externals['throw'] = function(message) {
        throw new Error(message || 'An exception from yate');
    };

    // eslint-disable-next-line no-unused-vars
    yr.externals['i18n-runtime'] = function(lang, locKey) {
        logger
            .verbose()
            .type('i18n')
            .write('Localizing %s for lang %s', Array.prototype.slice.call(arguments, 1), lang);

        var i18n = require('putils').i18n;

        return i18n.apply(i18n, arguments);
    };

    yr.externals['i18n-plural'] = function(lang, count, one, some, many) {
        var plural = tankerDinamic[lang] && tankerDinamic[lang].plural_adv;

        if (!plural) {
            return '';
        }

        return plural({
            count: count,
            one: one,
            some: some,
            many: many
        });
    };

    /**
     * Format the xml with escaped values
     * Values are escaped by yate when converting from scalar to xml
     *
     * @param {string} format
     * @param {string...} values
     * @returns {string}
     */
    // eslint-disable-next-line no-unused-vars
    yr.externals['format'] = function(format, values) {
        var args = Array.prototype.slice.call(arguments, 1);

        logger
            .verbose()
            .type('i18n')
            .write('Formatting %s with %s', format, args);

        var util = require('util');

        return util.format.apply(util, arguments);
    };

    /**
     * Spell month (1-12) with words
     *
     * @param {string} lang     two-letter lang code
     * @param {number} month    month number (1-12)
     * @returns {string}
     */
    yr.externals['spellMonth'] = function(lang, month) {
        if (typeof month !== 'number') {
            month = parseInt(month, 10);
        }

        require('assert')(month > 0 && month <= 12, 'Month should be month number');
        return require('putils').i18n(lang, 'time.month.' + (month - 1)); //Tanker months are 0 to 11
    };

    /**
     * Spell js month (0-11) in genetive case
     * @example января, февраля
     *
     * @param {string} lang     two-letter lang code
     * @param {number} month    month number in js Date format (0-11)
     * @returns {string}
     */
    yr.externals['spellMonthGen'] = function(lang, month) {
        if (typeof month !== 'number') {
            month = parseInt(month, 10);
        }

        require('assert')(month > 0 && month <= 12, 'Month should be month number');
        return require('putils').i18n(lang, 'time.month.gen.' + (month - 1)); //Tanker months are 0 to 11
    };

    /**
     * @param {string} str
     * @param {string|number} key
     * @param {string|number} val
     * @returns {string}
     */
    yr.externals['replace'] = function(str, key, val) {
        return str.replace(key, val);
    };
};
