passport.block('tokens-popup', {
    events: {
        'click .js-tokens-popup-close': 'closePopup'
    },

    openPopup: function() {
        this.paranja.removeClass('g-hidden');
    },

    closePopup: function() {
        this.paranja.addClass('g-hidden');
        $('.js-token').removeClass('token_state_open');
    },

    init: function() {
        this.paranja = $('.js-popup-paranja');
    }
});

passport.block('token-block', {
    events: {
        'click .js-token-toggle-i': 'toggleTokenInfoVisibility',
        click: 'showTokenInfo'
    },

    getParent: function(event) {
        if (!event) {
            return false;
        }

        return $(event.target).parents('.js-token');
    },

    showTokenInfo: function(event) {
        var parent = this.getParent(event);

        event.stopPropagation();

        if (!parent) {
            return;
        }

        parent.addClass('token_state_open');
    },

    toggleTokenInfoVisibility: function(event) {
        var parent = this.getParent(event);

        event.stopPropagation();

        if (!parent) {
            return;
        }

        parent.toggleClass('token_state_open');
    }
});

passport.block('passwd-settings', 'block', {
    events: {
        'click .js-edit-logout': 'showDeleteCheckbox'
    },

    showDeleteCheckbox: function() {
        $('.passwd-options').removeClass('g-hidden');
        $('.js-edit-logout-text').addClass('g-hidden');
    }
});
