/* eslint-env node */

var _ = require('lodash');
var config = require('../../configs/current');

module.exports = require('inherit')(
    require('pview'),
    {
        name: 'access.tokens',
        __constructor: function(appPasswordsEnabled, tokens, controller) {
            require('assert')(
                typeof appPasswordsEnabled === 'boolean',
                'App passwords enabled state should be a boolean'
            );
            require('assert')(
                Array.isArray(tokens) &&
                    tokens.every(function(token) {
                        return token instanceof require('papi/OAuth/models/Token');
                    }),
                'Tokens should be an array of Token Models'
            );

            this.__base.apply(this, arguments);
            this._tokens = tokens;
            this._appPasswordsEnabled = appPasswordsEnabled;
            this._controller = controller;
            this._oauthURL = config.paths.oauth.replace('%tld%', controller.getTld());
        },

        _compile: function() {
            var that = this;

            return {
                tokens: {
                    appPasswordsEnabled: this._appPasswordsEnabled,
                    appPasswordsTokens: this._tokens.some(function(token) {
                        return token.isAppPassword();
                    }),
                    list: this._tokens
                        .reverse() // PASSP-12897: Нужно добавлять последний добавленный токен/ПП в начало таблицы
                        .map(function(token) {
                            var isAppPassword = token.isAppPassword();
                            var hasDeviceId = Boolean(token.getDeviceId());
                            var issueTime = token.getIssueTime();
                            var extendedScopes;
                            var dateToChunks = that._controller.dateToChunks;

                            var base = {
                                isAppPassword: isAppPassword,
                                hasDeviceId: hasDeviceId,
                                id: token.getId(),
                                client: isAppPassword ? token.getClientSlug() : token.getClient().getTitle(),
                                isYandex: token.getClient().isYandex(),
                                clientIcon: token.getClient().getIcon(),
                                clientId: token.getClient().getId(),
                                clientDescription: token.getClient().getDescription(),
                                scopes: token.getScopes().map(function(scope) {
                                    return scope.getTitle();
                                }),
                                extendedScopes: [],
                                issueTime:
                                    Date.now() - that.__self.IRRELEVANT_ISSUE_TIME_CUTOFF < issueTime
                                        ? dateToChunks(issueTime, false)
                                        : null
                            };

                            extendedScopes = token.getScopes().groupBy(function(scope) {
                                return scope.getSectionTitle();
                            });

                            _.forEach(extendedScopes, function(scopes, section) {
                                var items = _.map(scopes, function(scope) {
                                    return scope.getTitle();
                                });

                                base.extendedScopes.push({
                                    section: section,
                                    items: items
                                });
                            });

                            if (hasDeviceId) {
                                _.assign(base, {
                                    deviceName: token.getDeviceName(),
                                    deviceId: token.getDeviceId()
                                });
                            }

                            return base;
                        })
                }
            };
        },
        oauthUrl: this._oauthURL
    },
    {
        IRRELEVANT_ISSUE_TIME_CUTOFF: 15552000000 //6 months in ms
    }
);
