/* borschik:include:MaChangedefault.js */

/* borschik:include:nanoislands.js */

/* borschik:include:../plibs/pclientjs/index.js */
/* borschik:include:../plibs/pheader/header.js */

passport.pin = (function() {
    var api = passport.api;
    var originalRequest = api.request;

    return function(uid) {
        var href = location.href;
        var search = location.search;
        var a = document.createElement('a');

        if (!uid) {
            // No uid to pin
            return;
        }

        // Hack api requests to have uid
        api.request = function(method, params, options) {
            var extendedParams = $.extend({}, params, {uid: uid});

            return originalRequest.call(api, method, extendedParams, options);
        };

        // f5
        if (window.history && typeof window.history.replaceState === 'function') {
            if (!/(\?|&)uid=/.test(location.search)) {
                a.href = href;
                a.search += location.search ? '&' : '?';
                a.search += 'uid=' + uid;
                href = a.href;
            } else {
                search = search.replace(/uid=\d*/, 'uid=' + uid);
                href = href.replace(location.search, search);
            }

            window.history.replaceState(null, document.title, href);
        }
    };
})();

/* global uid */
/* see layout.yate */
passport.pin(uid);

/* borschik:include:metrics/metrics.js */
/* borschik:include:form/form.js */
/* borschik:include:footer/footer.js */
/* borschik:include:control/checkbox/checkbox.js */
/* borschik:include:control/login/login.js */
/* borschik:include:control/login-preset/login-preset.js */
/* borschik:include:control/question/question.js */
/* borschik:include:control/password/password.js */
/* borschik:include:control/lastname/lastname.js */
/* borschik:include:control/surname/surname.js */
/* borschik:include:control/firstname/firstname.js */
/* borschik:include:control/fullname/fullname.js */
/* borschik:include:control/password-confirm/password-confirm.js */
/* borschik:include:control/password-current/password-current.js */
/* borschik:include:control/user-question/user-question.js */
/* borschik:include:control/answer/answer.js */
/* borschik:include:control/captcha/captcha.js */
/* borschik:include:control/submit/submit.js */
/* borschik:include:control/submit/submit-once/submit-once.js */
/* borschik:include:control/phone/phone.js */
/* borschik:include:control/checkbox/eula/eula.js */
/* borschik:include:control/checkbox/eula-money/eula-money.js */
/* borschik:include:control/tmx-frame/tmx-frame.js */
/* borschik:include:control/phone-confirm/phone-confirm.js */
/* borschik:include:control/human-confirmation/human-confirmation.js */
/* borschik:include:control/birthday/birthday.js */
/* borschik:include:control/login-simple/login-simple.js */
/* borschik:include:control/switch-login-phone/switch-login-phone.js */
/* borschik:include:control/pin/pin.js */
/* borschik:include:control/restore/restore.js */
/* borschik:include:control/gender/gender.js */
/* borschik:include:navigation/navigation.js */
