var _ = require('lodash');
var Field = require('pform/Field');
var QuestionField = require('../question/question.field');
var UserQuestionField = require('../user-question/user-question.field');

/**
 * @extends Field
 */
module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('answer')
            .setName('hint_answer')
            .setLabel('%field_hint_answer')
            .addError(new Field.Error('missingvalue', '%hint_answer_errors_missingvalue'))
            .addError(new Field.Error('toolong', '%hint_answer_errors_toolong'));
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData, api) {
        var validationParams;
        var questionField = new QuestionField();

        if (questionField.isUserQuestion(formData)) {
            validationParams = _(formData).pick(new UserQuestionField().getName(), this.getName());
        } else {
            validationParams = _(formData).pick(questionField.getName(), this.getName());
        }

        var that = this;

        return api
            .validateHint(
                validationParams
                    .mapValues(function(value) {
                        return that.normalizeValue(value);
                    })
                    .value()
            )
            .then(function(result) {
                if (!result.body) {
                    throw new Error('{ field: "password", body: <response> } expected');
                }

                return _.map(result.body.validation_errors || [], 'code');
            });
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    }
});
