var Field = require('pform/Field');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(Field, {
    //TODO: write tests for this field
    __constructor: function() {
        this._init('birthday')
            .setLabel('%field_birthday')
            .addError(new Field.Error('missingvalue', '%birthday_errors_missingvalue'))
            .addError(new Field.Error('invalid', '%birthday_errors_invalid'));
    },

    _dateFields: {
        day: 'bday',
        year: 'byear',
        month: 'bmonth'
    },

    _parseValue: function(formData) {
        var data = {};
        var that = this;

        Object.keys(this._dateFields).forEach(function(key) {
            data[key] = that.normalizeValue(formData[that._dateFields[key]]);
        });

        return data;
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    isPresent: function(formData) {
        assert(_.isObjectLike(formData), 'Argument should be a posted form data');
        return _.every(this._dateFields, function(val) {
            return val in formData;
        });
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    isEmpty: function(formData) {
        var parsedValue = this._parseValue(formData);
        var val = [parsedValue.year || '0000', parsedValue.month, parsedValue.day || '00'].join('-');

        return val === '0000-13-00';
    }
});
