(function() {
    var DEFAULT_MONTH = '13';

    passport.block('birthday', 'control', {
        updateTimeout: 0,
        needsServerValidation: false,
        isEmpty: function() {
            return this.val() === '0000-' + DEFAULT_MONTH + '-00';
        },
        isHalfAssed: function() {
            //TODO: this does not works in tests, since no markup exists in tests
            return (
                this._bday.val() === '' ||
                this._bmonth.val() === DEFAULT_MONTH ||
                this._byear.val() === '' ||
                this._byear.val().length < 4
            );
        },
        isCorrect: function() {
            var d = this._date();

            return d.getMonth() + 1 === ('0' + this._bmonth.val()).slice(-2);
        },
        isRequired: false,
        init: function() {
            this._bday = this.$('input[name="bday"]');
            this._bmonth = this.$('select[name="bmonth"]');
            this._byear = this.$('input[name="byear"]');
        },
        maxYear: new Date().getFullYear(),
        minYear: new Date().getFullYear() - 100,
        validate: function(suppressError) {
            var byearVal = Math.abs(Number(this._byear.val()));
            var bmonthVal = parseInt(this._bmonth.val(), 10);
            var bdayVal = Number(this._bday.val());
            var maxYear = this.maxYear;
            var minYear = this.minYear;
            var maxMonth = new Date().getMonth() + 1;
            var maxDay = new Date().getDate();

            if (this.isRequired && this.isEmpty()) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (!this.isRequired && this.isEmpty()) {
                this.validationResult(true, null, false);
                return;
            }

            if (this.isHalfAssed() && !this.isEmpty() && !isNaN(byearVal) && !isNaN(bdayVal)) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (isNaN(byearVal) || bdayVal < 0 || byearVal <= 0) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (
                byearVal === maxYear &&
                bmonthVal !== 13 &&
                bdayVal &&
                (bmonthVal > maxMonth || (bmonthVal === maxMonth && bdayVal > maxDay))
            ) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (byearVal && (byearVal < minYear || byearVal > maxYear)) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (!passport.util.isCorrectDate(this.val())) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            this.validationResult(true, null, false);
            return;
        },

        normalize: function(str, year) {
            var places = year ? '0000' : '0';
            var res = year ? -4 : -2;

            return (places + Math.abs(Number(str))).slice(res);
        },
        _date: function() {
            var split = this.val().split('-');

            return new Date(parseInt(split[0], 10), parseInt(split[1], 10) - 1, parseInt(split[2], 10));
        },
        val: function(value) {
            var t = this;
            var _n = t.normalize;
            var values;

            if (value) {
                values = value.split('-');
                this._byear.val(values[0]);
                this._bmonths.val(values[1]);
                this._bday.val(values[2]);
            }

            return [_n(t._byear.val(), true), _n(t._bmonth.val()), _n(t._bday.val())].join('-');
        }
    });
})();
