(function() {
    passport.block('captcha', 'control', {
        updateTimeout: 0,

        events: {
            'click .switch_to_audio': 'switchMode',
            'click .switch_to_text': 'switchMode',

            'click .captcha__captcha__audio': 'doPlayCaptcha',
            'click .another': 'getNewCaptcha',
            'click .another_embeddedauth': 'getNewCodeEmbeddedAuth',

            'click .pseudo_link': 'preventDefault',
            'switch_mode.captcha': 'trackMode',

            'click .js-captcha-check': 'checkCaptcha',
            'blur .js-captcha-field': 'onBlur'
        },

        checkCaptcha: function() {
            this.validate();
        },

        val: function() {
            var input = this.$('.p-control__input_name_captcha');

            return input.val.apply(input, arguments);
        },

        doPlayCaptcha: function(event) {
            event.preventDefault();
            this.play(this.audioCaptcha);
        },

        trackMode: function(event, mode) {
            this.$('.captcha_mode').val(mode);
        },

        preventDefault: function(event) {
            event.preventDefault();
        },

        init: function(options) {
            this.soundInitialized = false;
            this.soundNotAvailable = false;

            this.audioIntro = null;
            this.audioCaptcha = null;
            this.keyChanged = false;

            this.spinner = this.$('.js-captcha-spinner');

            // Only show the link if js is on
            this.$('.switch_to_audio').removeClass('g-hidden');

            this.mode = 'text';

            this.initSound();

            if (this.$('.captcha_mode').val() === 'audio') {
                this.switchMode(null, true);
            }

            this.needsServerValidation = (options && options.asyncCheck) || false;
            this.ocr = (options && options.ocr) || false;
            this.validConfirmation = this.$('.js-captcha__valid');

            if (options && options.popup) {
                this.popup = nb.block(document.getElementById('captcha-popup'));
            }
        },

        getValidationParams: function() {
            return {
                answer: this.val(),
                key: this.getKey(),
                passErrors: true
            };
        },

        switchMode: function(event, silent) {
            if (this.mode === 'text') {
                this.mode = 'audio';
                this.$el.addClass('audio').removeClass('text');

                if (!silent) {
                    this.play(this.audioIntro, this.play.bind(this, this.audioCaptcha));
                }
            } else {
                this.mode = 'text';
                this.$el.addClass('text').removeClass('audio');
                this.stop();
                this.getNewCode();
            }

            // TODO: only apply this hack if IE10
            var input = this.$('.p-control__input_name_captcha');

            input.addClass('ie10-repaint-fix');
            setTimeout(function() {
                input.removeClass('ie10-repaint-fix');
            }, 10);

            if (!silent) {
                this.error();
                this.focusInput();
            }

            this.emit('switch_mode', this.mode);
        },

        focusInput: function() {
            this.$('.captcha__input')
                .focus()
                .select();
        },

        initSound: function() {
            if (this.soundInitialized) {
                return;
            }

            this.switchButtonMode('loading');
            this.audioIntro = this.loadAudio(this.getVoiceIntroUrl());
            this.audioCaptcha = this.loadAudio(this.getVoiceUrl());
            this.switchButtonMode('play');

            this.soundInitialized = true;
        },

        setImage: function(url) {
            var self = this;
            var img = document.createElement('img');

            img.src = url;

            img.onload = function() {
                self.$('.captcha__captcha__text').attr({
                    src: img.src
                });
                self.hideSpinner();
            };
        },

        setVoiceUrl: function(url) {
            this.$('.voice_url').val(url);
        },

        getVoiceUrl: function() {
            return this.$('.voice_url').val();
        },

        setVoiceIntroUrl: function(url) {
            this.$('.voice_intro_url').val(url);
        },

        getVoiceIntroUrl: function() {
            return this.$('.voice_intro_url').val();
        },

        setKey: function(key) {
            this.$('.captcha_key').val(key);
        },

        getKey: function() {
            return this.$('.captcha_key').val();
        },

        captchaRequest: null,

        getNewCaptcha: function() {
            if (!this.mode || this.mode === 'text') {
                this.getNewCode();
                return;
            }

            this.stop();
            this.getNewAudioCode();
        },

        getNewCode: function() {
            var captchaMethod = 'textcaptcha';
            var args = {
                track_id: passport.track_id
            };

            if (passport.country) {
                args.country = passport.country;
            } else {
                args.language = passport.language;
            }

            if (this.ocr) {
                args.ocr = 'true';
            }

            this.showSpinner();

            this.captchaRequest = passport.api.request(captchaMethod, args, {
                cache: false,
                abortPrevious: true
            });

            this.captchaRequest.done(
                function(data) {
                    if (!data.key) {
                        return;
                    }

                    this.setImage(data.image_url);
                    this.setKey(data.key);

                    this.setVoiceUrl(data.voice.url);
                    this.audioCaptcha = this.loadAudio(data.voice.url);

                    if (!this.audioIntro) {
                        this.setVoiceIntroUrl(data.voice.intro_url);
                        this.audioIntro = this.loadAudio(data.voice.intro_url);
                    }

                    this.keyChanged = true;
                }.bind(this)
            );

            return this.captchaRequest;
        },

        getNewAudioCode: function() {
            var captchaMethod = 'audiocaptcha';

            if (this.mode !== 'text' && !this.soundNotAvailable) {
                this.switchButtonMode('loading');
                this.stop();
            }

            var args = {
                track_id: passport.track_id
            };

            if (passport.country) {
                args.country = passport.country;
            } else {
                args.language = passport.language;
            }

            this.captchaRequest = passport.api.request(captchaMethod, args, {
                cache: false,
                abortPrevious: true
            });

            this.captchaRequest.done(
                function(data) {
                    this.switchButtonMode('play');

                    if (!data.key) {
                        return;
                    }

                    this.setKey(data.key);

                    if (this.audioCaptcha && typeof this.audioCaptcha.unload === 'function') {
                        this.audioCaptcha.unload();
                    }

                    this.setVoiceUrl(data.voice.url);
                    this.audioCaptcha = this.loadAudio(data.voice.url);

                    if (!this.audioIntro || this.audioIntro.url !== data.voice.intro_url) {
                        this.setVoiceIntroUrl(data.voice.intro_url);
                        this.audioIntro = this.loadAudio(data.voice.intro_url);
                        this.play(this.audioIntro, this.play.bind(this, this.audioCaptcha));
                    } else {
                        this.play(this.audioCaptcha);
                    }

                    this.keyChanged = false;
                }.bind(this)
            );

            return this.captchaRequest;
        },

        getNewCodeEmbeddedAuth: function(event) {
            if (event) {
                event.preventDefault();
            }

            this.showSpinner();

            if (!this.captchaImageEmbedded) {
                this.captchaImageEmbedded = this.$('.captcha__captcha__text').attr('src');
            }

            var url = this.captchaImageEmbedded + '&cantread=1&ncrnd=' + parseInt(Math.random() * 100000, 10);

            this.setImage(url);
            return this;
        },

        showSpinner: function() {
            this.spinner.removeClass('g-hidden');
        },

        hideSpinner: function() {
            this.spinner.addClass('g-hidden');
        },

        audioFailed: function() {
            this.switchButtonMode('play');
            this.$('.audio_system_failed').removeClass('g-hidden');
            this.$('.captcha__captcha__audio').addClass('is-disabled');
            this.soundNotAvailable = true;
        },

        loadAudio: function(url) {
            if (!url) {
                return null;
            }

            var loaded = new $.Deferred();
            var Howl = window.Howl;
            var audio = new Howl({
                src: url,
                html5: true,
                preload: true,
                format: ['mp3']
            });

            audio.on('load', function() {
                loaded.resolve();
            });

            audio.on('loaderror', function() {
                loaded.reject();
            });

            var timeout = setTimeout(function() {
                // If still pending
                if (loaded.state() === 'pending') {
                    // Explicitly fail in 2 minutes
                    loaded.reject();
                }
            }, 2 * 60 * 1000);

            loaded
                .done(
                    function() {
                        this.hideSpinner();
                        clearTimeout(timeout);
                    }.bind(this)
                )
                .fail(
                    function() {
                        // Биндинг напрямую на audioFailed портит внутреннее устройство sinon.spy и проваливает тесты
                        this.hideSpinner();
                        this.audioFailed();
                    }.bind(this)
                );

            audio.isLoaded = loaded;

            return audio;
        },

        switchButtonMode: function(mode) {
            var modes = ['play', 'playing', 'loading'];
            var modePosition = modes.indexOf(mode);

            if (modePosition < 0) {
                throw 'Unknown mode';
            }

            modes.splice(modePosition, 1);
            this.$('.captcha__captcha__audio')
                .removeClass(modes.join(' '))
                .addClass(mode);
        },

        play: function(sound, whenFinishedCallback) {
            var self = this;

            if (!this.soundInitialized) {
                this.initSound();
                return;
            }

            if (
                this.soundNotAvailable ||
                !sound ||
                sound.playState // Sound is already playing
            ) {
                return;
            }

            function whenSoundReady(callback) {
                $.when(sound.isLoaded).done(function() {
                    callback();
                });
            }

            whenSoundReady(function() {
                self.stop();
                self.switchButtonMode('playing');

                sound.on('end', function() {
                    self.switchButtonMode('play');

                    if (whenFinishedCallback) {
                        whenFinishedCallback();
                    }
                });

                sound.play();
            });
        },

        stop: function() {
            function existsAndResolved(sound) {
                return sound && sound.isLoaded && sound.isLoaded.state() === 'resolved';
            }

            if (existsAndResolved(this.audioCaptcha)) {
                this.audioCaptcha.stop();
            }

            if (existsAndResolved(this.audioIntro)) {
                this.audioIntro.stop();
            }

            this.switchButtonMode('play');
        },

        disableControl: function() {
            this.$('.p-control__input_name_captcha')
                .addClass('is-disabled')
                .attr('disabled', true);
            this.$('.js-captcha__switch').addClass('g-hidden');
        },

        enableControl: function() {
            this.$('.p-control__input_name_captcha')
                .removeClass('is-disabled')
                .removeAttr('disabled');
            this.$('.js-captcha__switch').removeClass('g-hidden');
            this.validConfirmation.addClass('g-hidden');
        },

        validationCallback: function(data) {
            if (data.errors) {
                if (data.errors[0].code === 'unknowntrack' || data.errors[0].code === 'unknownnode') {
                    // что-то не так с треком, начать все сначала https://st.yandex-team.ru/PASSP-12620
                    window.location.reload();
                }
            }

            this.validConfirmation.addClass('g-hidden');

            if (!data.correct) {
                if (!data.errors) {
                    this.validationResult(false, 'incorrect');
                }

                this.emit('incorrect');
                this.getNewCaptcha();
            } else {
                this.validationResult(true);
                this.validConfirmation.removeClass('g-hidden');
                this.emit('correct');
                this.disableControl();
            }

            return data.correct;
        },

        clearCaptcha: function() {
            this.val('');
            this.error();
            this.getNewCaptcha();
            this.enableControl();
        },

        enableCaptcha: function() {
            if (this.popup && typeof this.popup.open === 'function') {
                this.clearCaptcha();
                this.popup.open({
                    how: {
                        autoclose: false
                    }
                });
            }
        },

        closeCaptcha: function() {
            if (this.popup && typeof this.popup.close === 'function') {
                this.popup.close();
            }
        },

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        }
    });
})();
