var Field = require('pform/Field');

/**
 * @extends Field
 */
module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('eula-money')
            .setName('money_eula_accepted')
            .setLabel('%money.acceptance.money');
    },

    _parseValue: function(formData) {
        return formData[this.getName()];
    },

    isEmpty: function(formData) {
        var value = this._parseValue(formData);

        return !value || ['on', '1', 'true'].indexOf(value.toString()) === -1;
    },

    onValid: function() {
        this.setValue('on');
    },

    getErrors: function() {
        return [];
    }
});
