var Field = require('pform/Field');

/**
 * @extends Field
 */
module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('eula')
            .setName('eula_accepted')
            .setLabel('%acceptance.register_2')
            .addError(new Field.Error('missingvalue', '%eula_accepted_errors_missingvalue'));
    },

    _parseValue: function(formData) {
        return formData[this.getName()];
    },

    isEmpty: function(formData) {
        var value = this._parseValue(formData);

        return !value || ['on', '1', 'true'].indexOf(value.toString()) === -1;
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onValid: function() {
        this.setValue('on');
    }
});
