(function() {
    passport.block('confirm-method', 'control', {
        needsServerValidation: false,

        init: function() {
            ['phone-confirm', 'captcha', 'password', 'password-confirm', 'submit'].forEach(function(controlName) {
                passport.block(controlName).inited.done(function(control) {
                    control.$el.hide();
                });
            });
        },

        events: {
            'validation.history-answer': 'showPhone'
        },

        error: function() {},

        showPhone: function(e, isValid, error) {
            $('.js-compare-not-matched').addClass('g-hidden');
            if (!error) {
                ['history-question', 'history-answer'].forEach(function(controlName) {
                    passport.block(controlName).inited.done(function(control) {
                        control.$el.hide();
                    });
                });
                ['phone-confirm', 'captcha', 'password', 'password-confirm', 'submit'].forEach(function(controlName) {
                    passport.block(controlName).inited.done(function(control) {
                        control.$el.show();
                    });
                });
                $('.js-bind-phone-message').removeClass('g-hidden');
            }

            if (error && (error === 'ratelimit_exceeded' || error[0] === 'ratelimit_exceeded')) {
                $('.js-rate-exceeded').removeClass('g-hidden');
            }

            if (error && (error === 'comparenot_matched' || error[0] === 'comparenot_matched')) {
                $('.js-compare-not-matched').removeClass('g-hidden');
            }
        }
    });
})();
