(function() {
    var currentAnswer = passport.block('current-answer', 'control', {
        init: function() {
            passport.block('current-question').inited.done(
                function(question) {
                    this.currentQuestion = question.val();
                }.bind(this)
            );
        },
        updateTimeout: 0,
        needsServerValidation: true,
        isRequired: true,

        events: {
            'click .init-confirm': 'initValidation',
            'validation.current-answer': 'setCompleted'
        },

        getValidationParams: function() {
            return {
                current_answer: this.val(),
                current_question: this.currentQuestion
            };
        },

        initValidation: function(event) {
            event.preventDefault();
            this.validate();
        },

        setCompleted: function(e, isValid, error) {
            if (!error) {
                this.$('.init-confirm').addClass('g-hidden');
                this.$('.p-control__valid').removeClass('g-hidden');
                this.disableControl();
                this.emit('answerChecked');
            }
        },

        disableControl: function() {
            this.$ctrl.addClass('is-disabled');
        },

        enableControl: function() {
            this.$ctrl.prop('disabled', false).removeClass('is-disabled');
        }
    });

    passport.mixins.clickNextButtonOnEnterInsideInput(currentAnswer);
})();
