var Field = require('pform/Field');
var GenericNameField = require('../nameField');

/**
 * @extends GenericNameField
 */
var FirstnameField = require('inherit')(GenericNameField, {
    __constructor: function() {
        this._init('firstname')
            .setLabel('%field_firstname')
            .addError(new Field.Error('missingvalue', '%firstname_errors_missingvalue'))
            .addError(new Field.Error('toolong', '%firstname_errors_toolong'));
    },

    isEmpty: function(formData) {
        if (this._values.options && this._values.options.multiplyFields) {
            return !this._parseValue(formData)['values'].length;
        } else {
            return !this._parseValue(formData);
        }
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    }
});

module.exports = FirstnameField;
