var _ = require('lodash');
var when = require('when');

var Form = require('pform');
var Field = require('pform/Field');
var FirstnameField = require('../firstname/firstname.field');
var LastnameField = require('../lastname/lastname.field');

/**
 * @extends Field
 */
var Fullname = require('inherit')(Field, {
    __constructor: function() {
        this._init('fullname');

        this._firstname = new FirstnameField();
        this._lastname = new LastnameField();
    },

    _getForm: function() {
        return new Form(this._firstname.setRequired(), this._lastname.setRequired());
    },

    validate: function(formData, api) {
        var form = this._getForm();

        form.setApi(api);
        return form.validate(formData).then(function() {
            return [];
        });
    },

    compile: function(lang, api) {
        var compiled = this.__base.call(this, lang);

        var promises = [];
        var names = [];

        _.each(
            {
                firstname: this._firstname,
                lastname: this._lastname
            },
            function(field, name) {
                promises.push(field.compile(lang, api));
                names.push(name);
            }
        );

        return when.all(promises).then(function(results) {
            for (var i = 0; i < results.length; i++) {
                compiled[names[i]] = results[i];
            }

            return compiled;
        });
    },

    normalize: function(formData) {
        return _.extend(this._getForm().normalize(formData), this.__base.call(this, formData));
    }
});

module.exports = Fullname;
