(function() {
    var SELECTOR_POPUP_NODE = '.p-control__input_name_lastname';

    passport.block('fullname', 'control', {
        updateTimeout: 0,
        needsServerValidation: false,

        events: {
            'validation.firstname': 'onValidateFirstname',
            'validation.lastname': 'onValidateLastname'
        },

        init: function() {
            this.nbPopup = nb.block(this.$('.js-fullname-popup').get(0));

            this.subBlocks = {
                firstname: passport.block('firstname'),
                lastname: passport.block('lastname')
            };

            this.nbErrorParams = {
                where: this.$(SELECTOR_POPUP_NODE)
            };

            //Altering the subblocks functionality
            var blockLastName = passport.block('lastname');
            var blockFirstName = passport.block('firstname');

            $.when(blockFirstName.inited, blockLastName.inited).done(function() {
                blockFirstName.nbErrorParams = blockLastName.nbErrorParams = {
                    where: blockLastName.$('.p-control__input_name_lastname').get(0)
                };
            });

            var originLastnameError = blockLastName.error;

            blockLastName.error = function() {
                if (!blockFirstName.nbctrl || !blockFirstName.nbctrl.error || !blockFirstName.nbctrl.error.isOpen()) {
                    originLastnameError.apply(this, arguments);
                }
            };

            var originFirstnameError = blockFirstName.error;

            blockFirstName.error = function() {
                if (!blockLastName.nbctrl || !blockLastName.nbctrl.error || !blockLastName.nbctrl.error.isOpen()) {
                    originFirstnameError.apply(this, arguments);
                }
            };
        },

        validate: function() {
            var deferred = new $.Deferred();

            if (!this.inited.already) {
                deferred.reject();
                return deferred;
            }

            var that = this;
            var subblocks = [this.subBlocks.firstname, this.subBlocks.lastname];

            $.when
                .apply(
                    $,
                    subblocks.map(function(block) {
                        return block.validate();
                    })
                )
                .then(
                    function() {
                        var allValid = subblocks.every(function(block) {
                            return passport.validator.check(block);
                        });

                        that.validationResult(allValid);
                        deferred.resolve();
                    },
                    function() {
                        deferred.reject();
                    }
                );

            return deferred;
        },

        serverValidate: function() {
            this.emit('validation', true);
            return new $.Deferred().resolve(true);
        },

        validationCallback: function(data) {
            if (!data.isCorrectName && !this.isValidPassword()) {
                this.showPopup();
            }
            this.validationResult(true);
        },

        isValidPassword: function() {
            return passport.validator.check(passport.block('password'));
        },

        showPopup: function() {
            this.nbPopup.open({
                where: SELECTOR_POPUP_NODE,
                how: {
                    at: 'right',
                    my: 'left'
                }
            });
        },

        getHandleID: function() {
            return this.id;
        },

        hasEmptyField: function() {
            return [this.subBlocks.firstname, this.subBlocks.lastname].some(function(control) {
                return control.inited.already !== true || passport.validator.check(control) === false;
            });
        },

        onValidateFirstname: function(e, result) {
            if (!this.subBlocks.firstname.isEmpty()) {
                this.subBlocks.firstname.isChanged = true;
            }

            if (!result) {
                return;
            }

            if (this.isValidLastname()) {
                this.serverValidate();
            } else if (this.subBlocks.lastname.isChanged) {
                this.subBlocks.lastname.validate();
            }
        },

        onValidateLastname: function(e, result) {
            if (!this.subBlocks.lastname.isEmpty()) {
                this.subBlocks.lastname.isChanged = true;
            }

            if (!result) {
                return;
            }

            if (this.isValidFirstname()) {
                this.serverValidate();
            } else if (this.subBlocks.firstname.isChanged) {
                this.subBlocks.firstname.validate();
            }
        },

        isValidFirstname: function() {
            return passport.validator.check(this.subBlocks.firstname) === true;
        },

        isValidLastname: function() {
            return passport.validator.check(this.subBlocks.lastname) === true;
        },

        val: function() {
            if (!this.subBlocks.firstname.inited.already || !this.subBlocks.lastname.inited.already) {
                return '';
            }

            return this.subBlocks.firstname.val() + ' ' + this.subBlocks.lastname.val();
        },

        error: $.noop
    });
})();
