(function() {
    var historyAnswer = passport.block('history-answer', 'control', {
        init: function() {
            passport.block('history-question').inited.done(
                function(question) {
                    this.currentQuestion = question.val();
                }.bind(this)
            );
        },
        updateTimeout: 0,
        needsServerValidation: true,
        isRequired: true,

        events: {
            'click .js-init-confirm': 'initValidation',
            'update.history-question': 'onQuestionUpdate',
            'validation.history-answer': 'setCompleted'
        },

        getValidationParams: function() {
            return {
                history_answer: this.val(),
                history_question: this.currentQuestion
            };
        },

        initValidation: function(event) {
            event.preventDefault();
            this.validate();
        },

        setCompleted: function(e, isValid, error) {
            if (!error) {
                this.$('.js-init-confirm').addClass('g-hidden');
                this.$('.p-control__valid').removeClass('g-hidden');
                this.disableControl();
                this.emit('answerChecked');
            }
        },

        disableControl: function() {
            this.$ctrl.addClass('is-disabled');
        },

        enableControl: function() {
            this.$ctrl.prop('disabled', false).removeClass('is-disabled');
        },

        onQuestionUpdate: function(event, changes) {
            this.currentQuestion = changes.shift();
        }
    });

    passport.mixins.clickNextButtonOnEnterInsideInput(historyAnswer);
})();
