var Field = require('pform/Field');
var QuestionField = require('../question/question.field');
var assert = require('assert');
var _ = require('lodash');

/**
 * @extends Field
 */
var HistoryQuestionField = require('inherit')(Field, {
    __constructor: function() {
        this._init('history-question')
            .setName('history_question')
            .setLabel('%field_hint_question_id')
            .addError(new Field.Error('missingvalue', '%hint_question_errors_missingvalue'))
            .addError(new Field.Error('toolong', '%hint_question_errors_toolong'));
    },

    isEmpty: function(formData) {
        if (!new QuestionField().isUserQuestion(formData)) {
            return false;
        }

        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    _parseValue: function(formData) {
        return {
            text: formData[this.getName()],
            id: formData[`${this.getName()}_id`]
        };
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    setQuestions: function(data) {
        this._questions = data || [];
    }
});

module.exports = HistoryQuestionField;
