var Field = require('pform/Field');
var GenericNameField = require('../nameField');

/**
 * @extends GenericNameField
 */
var LastnameField = require('inherit')(GenericNameField, {
    __constructor: function() {
        this._init('lastname')
            .setLabel('%field_lastname')
            .addError(new Field.Error('missingvalue', '%lastname_errors_missingvalue'))
            .addError(new Field.Error('toolong', '%lastname_errors_toolong'));
    },

    isEmpty: function(formData) {
        if (this._values.options && this._values.options.multiplyFields) {
            return !this._parseValue(formData)['values'].length;
        } else {
            return !this._parseValue(formData);
        }
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    }
});

module.exports = LastnameField;
