var LoginField = require('../login/login.field');

/**
 * @extends LoginField
 */
module.exports = require('inherit')(LoginField, {
    __constructor: function() {
        //Тырим оригинальные ошибки
        this.__base();
        var errors = this.getErrors();

        this._init('login-preset')
            .setName(new LoginField().getName()) //Мимикрируем под логин, перехватываем инпут
            .setLabel('%your_extra_login_label');

        errors.forEach(this.addError.bind(this));
    },

    compile: function(lang) {
        var compiled = this.__base.call(this, lang);

        compiled.login = new LoginField().compile(lang);
        return compiled;
    }
});
