(function() {
    passport.block('login-preset', 'control', {
        init: function() {
            this.loginBlock = passport.block('login');

            this.showPreset();
            if (this.loginBlock.inited.already) {
                return this.loadFirstSuggest(passport.block('login'));
            } else {
                return this.loginBlock.inited.done(this.loadFirstSuggest.bind(this));
            }
        },

        loadFirstSuggest: function(login) {
            var that = this;
            var finished = new $.Deferred();

            login.enableSuggestion();
            login
                .loadSuggest()
                .done(function(suggestions) {
                    var suggestion = suggestions[0];

                    if (suggestion) {
                        that.preset(suggestion);
                    } else {
                        that.pickAnother();
                    }

                    finished.resolve();
                })
                .fail(function() {
                    that.pickAnother();
                    finished.resolve();
                });

            return finished;
        },

        preset: function(login) {
            if (this.loginBlock.val()) {
                return;
            }
            this.val(login);
            var firstLetter = login.charAt(0);
            var allButFirstLetter = login.substr(1);

            this.$('.preset__login__first-letter').html(passport.util.escape(firstLetter));
            this.$('.preset__login__rest').html(passport.util.escape(allButFirstLetter));

            this.loginBlock.val(login);
            this.showPreset();
        },

        validate: function() {
            // This block should be valid if login block is valid.
            return this.loginBlock.validate();
        },

        events: {
            'click .preset__another': 'pickAnother',
            'keydown .preset__another': 'pickAnother'
        },

        showPreset: function() {
            this.$('.preset').removeClass('g-hidden');
            this.$('.change').addClass('g-hidden');
        },

        focus: function() {
            this.loginBlock.$ctrl.focus();
        },

        val: function() {
            if (this.loginBlock.inited.already) {
                return this.loginBlock.val.apply(this.loginBlock, arguments);
            }

            return '';
        },

        pickAnother: function(event) {
            var isKeyboardSubmit = passport.util.isKeyboardSubmit(event);

            if (!passport.util.isKeyboardEvent(event) || isKeyboardSubmit) {
                this.val('');
                this.$('.preset, .change').toggleClass('g-hidden');
                if (event) {
                    this.loginBlock.$ctrl.focus();
                }

                if (this.inited.already) {
                    passport.api.log('login-preset: preset was changed');
                }
            }

            if (isKeyboardSubmit) {
                event.preventDefault();
            }
        }
    });
})();
