const config = require('../../../configs/common');
const Field = require('pform/Field');

const LoginField = require('inherit')(Field, {
    __constructor: function() {
        this._init('login-simple')
            .setLabel('%your_login')
            .addError(new Field.Error('missingvalue', '%login_simple_errors_missingvalue'))
            .addError(new Field.Error('prohibitedsymbols', '%login_simple_errors_prohibitedsymbols'));
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    },

    compile: function(lang, api) {
        const compiled = this.__base.apply(this, arguments);

        return api.restoreLoginsSuggest().then(function(response = {}) {
            const {body = {}} = response;
            const {status, suggested_logins: suggestedLogins = []} = body;

            const suggest =
                (status === 'ok' &&
                    suggestedLogins.filter(
                        (item = {}) => item.login && !item.login.startsWith(config.neoPhonishPrefix)
                    )) ||
                null;

            return Object.assign({}, compiled, {suggest});
        });
    }
});

module.exports = LoginField;
