(function() {
    var spacesRegEx = /\s/;

    passport.block('login-simple', 'control', {
        needsServerValidation: false,

        events: {
            'click .js-suggest-item': 'setValue',
            'click .js-dunno-login': 'onDunnoLogin',
            'blur #login-simple': 'onBlur'
        },

        validate: function(suppressError) {
            if (this.isRequired && this.isEmpty()) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (spacesRegEx.test(this.val().trim())) {
                this.validationResult(false, 'prohibitedsymbols', suppressError);
                return;
            }

            this.validationResult(true, null, false);
            return;
        },

        setValue: function(event) {
            var suggest = (event && event.target && $(event.target).data('login')) || '';

            if (!suggest.length) {
                return;
            }

            this.val(suggest);
            this.emit('onSuggestItemClick');
            this.$ctrl.focus();
        },

        onDunnoLogin: function() {
            this.emit('onDunnoLoginClick');
        },

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        }
    });
})();
