var _ = require('lodash');
var Field = require('pform/Field');

/**
 * @extends Field
 */
var LoginField = require('inherit')(Field, {
    __constructor: function() {
        this._init('login')
            .setLabel('%field_login')
            .addError(new Field.Error('missingvalue', '%login_errors_missingvalue'))
            .addError(new Field.Error('invalid', '%login_errors_invalid'))
            .addError(new Field.Error('domain_invalid_type', '%login_errors_invalid'))
            .addError(new Field.Error('not_available', '%login_errors_notavailable'))
            .addError(new Field.Error('prohibitedsymbols', '%login_errors_prohibitedsymbols'))
            .addError(new Field.Error('startswithdigit', '%login_errors_startswithdigit'))
            .addError(new Field.Error('toolong', '%login_errors_toolong'))
            .addError(new Field.Error('long', '%login_errors_toolong'))
            .addError(new Field.Error('startswithdot', '%login_errors_startswithdot'))
            .addError(new Field.Error('startswithhyphen', '%login_errors_startswithhyphen'))
            .addError(new Field.Error('endswithhyphen', '%login_errors_endswithhyphen'))
            .addError(new Field.Error('doubleddot', '%login_errors_doubleddot'))
            .addError(new Field.Error('doubledhyphen', '%login_errors_doubledhyphen'))
            .addError(new Field.Error('dothyphen', '%login_errors_dothyphen'))
            .addError(new Field.Error('hyphendot', '%login_errors_hyphendot'))
            .addError(new Field.Error('endwithdot', '%login_errors_endswithdot'));
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData, api) {
        var value = this.normalizeValue(formData[this.getName()]);
        var data = {
            login: value
        };

        if (!value) {
            this.getErrorByCode('missingvalue').setActive();
            return false;
        }

        if (formData.is_lite) {
            data.is_lite = 1;
        }

        return api
            .validateLogin(data)
            .then(function() {
                return _.map([], 'code');
            })
            .catch(function(error) {
                return _.map(error);
            });
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        var code = this.getErrorCodeFromData(errors[0]);
        var error = this.getErrorByCode(code);

        if (formData.is_lite === '1') {
            this.setOption('isLite', 1);
        }
        this.setValue(this._parseValue(formData));
        if (error) {
            error.setActive(); // PASSP-16439
        }
    },

    getErrorCodeFromData: function(data) {
        var code;
        var controlName = 'login';
        var prefix = data.slice(0, controlName.length);

        if (prefix === controlName) {
            code = data.slice(controlName.length + 1);
        } else {
            code = data.replace('.', '_');
        }

        return code;
    }
});

module.exports = LoginField;
