/* eslint-env node */

/**
 * @extends Field
 */
module.exports = require('inherit')(require('pform/Field'), {
    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData) {
        if (this.normalizeValue(formData[this.getName()]).length > 50) {
            return ['toolong'];
        }

        return [];
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    }
});
