var Field = require('pform/Field');
var PasswordField = require('../password/password.field');

/**
 * @extends Field
 */
var PasswordConfirm = require('inherit')(Field, {
    __constructor: function() {
        this._init('password-confirm')
            .setName('password_confirm')
            .setLabel('%field_password_confirm')
            .addError(new Field.Error('missingvalue', '%password_confirm_errors_missingvalue'))
            .addError(new Field.Error('notequal', '%password_confirm_errors_notequal'));
    },

    _parseValue: function(formData) {
        return formData[this.getName()];
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData) {
        if (formData[this.getName()] !== formData[new PasswordField().getName()]) {
            return ['notequal'];
        }

        return [];
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    }
});

module.exports = PasswordConfirm;
