var VALIDATION_FAILED = false;
var VALIDATION_PASSED = true;

(function() {
    passport.block('password-confirm', 'control', {
        needsServerValidation: false,

        /**
         * Store current password for validation purposes
         */
        currentPassword: '',

        init: function() {
            this.validConfirmation = this.$('.password-confirm__valid');
        },

        events: {
            'visibilityChange.password': 'changeVisibility',
            'update.password': 'onPasswordUpdate',
            'blur #password_confirm': 'onBlur'
        },

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        },

        changeVisibility: function(event, newType) {
            this.$ctrl.attr({type: newType});
        },

        validate: function(suppressError) {
            var confirmation = this.val();

            this.validConfirmation.addClass('g-hidden');

            if (confirmation.length === 0) {
                this.validationResult(VALIDATION_FAILED, 'missingvalue', suppressError);
                return;
            }

            // Check confirmation if there is anything to confirm:
            if (this.currentPassword.length > 0 && confirmation.length > 0) {
                if (confirmation !== this.currentPassword) {
                    this.validationResult(VALIDATION_FAILED, 'notequal');
                } else {
                    this.validationResult(VALIDATION_PASSED, null);
                    this.validConfirmation.removeClass('g-hidden');
                }
            } else {
                this.validationResult(VALIDATION_PASSED, null);
            }
        },

        onPasswordUpdate: function(event, change) {
            this.currentPassword = change.shift();
            this.validate(true);
        }
    });
})();
