var Field = require('pform/Field');

var PasswordCurrent = require('inherit')(Field, {
    __constructor: function() {
        this._init('current-password')
            .setName('current_password')
            .setLabel('%field_password_current')
            .addError(new Field.Error('invalid', '%password_current_errors_invalid'))
            .addError(new Field.Error('not_matched', '%password_current_errors_not_matched'))
            .addError(new Field.Error('missingvalue', '%password_current_errors_missingvalue'))
            .addError(new Field.Error('prohibitedsymbols', '%password_errors_prohibitedsymbols'));
    },

    _parseValue: function(formData) {
        return formData[this.getName()];
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    }
});

module.exports = PasswordCurrent;
