var _ = require('lodash');
var Field = require('pform/Field');
var LoginField = require('../login/login.field');
var PhoneField = require('../phone-confirm/phone-confirm.field');

/**
 * @extends Field
 */
var PasswordField = require('inherit')(Field, {
    __constructor: function() {
        this._init('password')
            .setLabel('%field_password')
            .addError(new Field.Error('missingvalue', '%password_errors_missingvalue'))
            .addError(new Field.Error('likelogin', '%password_errors_likelogin'))
            .addError(new Field.Error('tooshort', '%password_errors_tooshort'))
            .addError(new Field.Error('weak', '%password_errors_weak'))
            .addError(new Field.Error('prohibitedsymbols', '%password_errors_prohibitedsymbols'))
            .addError(new Field.Error('likeoldpassword', '%password_errors_equals_previous'))
            .addError(new Field.Error('foundinhistory', '%password_errors_foundinhistory'))
            .addError(new Field.Error('likephonenumber', '%password_errors_likephonenumber'))
            .addError(new Field.Error('toolong', '%password_errors_toolong'));
    },

    _parseValue: function(formData) {
        return formData[this.getName()];
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData, api) {
        return api
            .validatePassword(_.pick(formData, new LoginField().getName(), this.getName(), new PhoneField().getName()))
            .then(function(result) {
                if (!result.body) {
                    throw new Error('{ field: "password", body: <response> } expected');
                }

                return _.map(result.body.validation_errors || [], 'code');
            });
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    }
});

module.exports = PasswordField;
