(function() {
    passport.block('password', 'control', {
        controlSelector: '.p-control__input_name_password',

        init: function() {
            this.passwordToggleControls = this.$('.toggleVisibility');

            this.canSwitchInputType = true;
            this.checkIfCanSwitchFieldType();

            if (!this.canSwitchInputType) {
                this.disablePasswordToggleControls();
            }

            var legend_template = $('<span class="password-legend"></span>');

            $.each(
                ['tooshort', 'weak', 'toolong'],
                function(index, errorCode) {
                    this.getErrorByCode(errorCode).append(legend_template.clone());
                }.bind(this)
            );
            this.$('.password-ok').append(legend_template.clone());
            this.passwordLegends = this.$('.password-legend');

            this.strengthIndicator = this.$('.password-indicator__i');
            this.symbolsDict = {
                one: i18n('%symbol_one'),
                some: i18n('%symbol_some'),
                many: i18n('%symbol_many')
            };

            this.passwordAcceptableMsg = $('.password-ok');

            this.phoneStage = 'entry';
            this.currentPhone = '';

            passport.block('login').inited.done(
                function(login) {
                    this.currentLogin = login.val();
                }.bind(this)
            );

            this.emit('showEntry');
        },

        events: {
            'click .toggleVisibility': 'toggleVisibility',
            'update.password': 'onPasswordUpdate',
            'validation.password': 'onPasswordValidation',
            'show.phone-confirm': 'onPhoneConfirmSwitchStage',
            'codeSent.phone-confirm': 'onPhoneConfirmCodeSent',
            'update.login': 'onLoginUpdate',
            'click .js-passwd_how_to': 'toggleHowTo',
            'blur #password': 'onBlur'
        },

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        },

        isEmpty: function() {
            return this.val().length === 0;
        },

        /**
         * @param {String} code
         * @returns $
         */
        getErrorByCode: function(code) {
            return this.$('.p-control__error__' + this.id + '_' + code);
        },

        onPasswordUpdate: function() {
            var passwordLength = this.val().length;

            this.updateIndicator(passwordLength);
            this.updatePasswordLegends(passwordLength);
        },

        updateIndicator: function(passwordLength) {
            this.strengthIndicator.css({
                width: Math.min((Math.log((passwordLength || 0) + 1) / Math.log(255)) * 100, 100) + '%'
            });
        },

        updatePasswordLegends: function(passwordLength) {
            this.passwordLegends.html(
                ', ' +
                    passwordLength +
                    '&#160;' +
                    i18n['tanker']['dynamic']['plural']({
                        count: passwordLength,
                        one: this.symbolsDict['one'],
                        some: this.symbolsDict['some'],
                        many: this.symbolsDict['many']
                    })
            );
        },

        validationCallback: function(data, suppressError) {
            if (data.validation_errors) {
                this.validationResult(
                    /* Validation failed */ false,
                    passport.validator.getErrorCode(data.validation_errors),
                    suppressError
                );
            } else if (data.validation_warnings) {
                this.validationResult(
                    /* Validation passed */ true,
                    passport.validator.getErrorCode(data.validation_warnings),
                    suppressError
                );
            } else {
                this.validationResult(/* Validation passed */ true, null, suppressError);
            }
        },

        validationResult: function(result, errorCode, suppressError) {
            if (!suppressError) {
                this.error(errorCode);
                this.emit('validation', result, errorCode);
            }
        },

        onLoginUpdate: function(event, changes) {
            this.updateLogin(changes.shift());
        },

        updateLogin: function(newLogin) {
            this.currentLogin = newLogin;

            if (!this.isEmpty()) {
                this.validate();
            }
        },

        onPhoneConfirmCodeSent: function(e, number) {
            this.currentPhone = number;

            if (!this.isEmpty()) {
                this.validate();
            }
        },

        onPhoneConfirmSwitchStage: function(e, stage) {
            this.phoneStage = stage;
            if (this.phoneStage === 'entry') {
                this.currentPhone = '';
            }

            if (!this.isEmpty()) {
                this.validate();
            }
        },

        getValidationParams: function() {
            return {
                password: this.val(),
                login: this.currentLogin,
                phoneStage: this.phoneStage,
                phone_number: this.currentPhone
            };
        },

        /**
         * Show errors after password was validated
         *
         * @param {jQuery.event} event
         * @param {Boolean} result
         * @param {String} errorCode
         */
        onPasswordValidation: function(event, result, errorCode) {
            if (result) {
                if (errorCode) {
                    // Warning
                    this.strengthIndicator.css({background: 'orange'});
                    this.getErrorByCode('weak')
                        .css({color: 'orange'})
                        .removeClass('g-hidden');

                    this.passwordAcceptableMsg.addClass('g-hidden');
                } else {
                    // Passed
                    this.strengthIndicator.css({background: 'green'});
                    this.passwordAcceptableMsg.removeClass('g-hidden');
                }
            } else {
                // Error
                this.strengthIndicator.css({background: 'red'});
                this.getErrorByCode('weak').css({color: '#BB0000'});
                this.passwordAcceptableMsg.addClass('g-hidden');
            }
        },

        checkIfCanSwitchFieldType: function() {
            var testInput = document.createElement('input');

            testInput.type = 'text';
            testInput.style.position = 'absolute';
            testInput.style.top = '0';
            testInput.style.left = '-2000px';
            document.body.appendChild(testInput);

            try {
                testInput.type = 'password';
            } catch (e) {
                this.canSwitchInputType = false;
            }

            testInput.style.display = 'none';
        },
        disablePasswordToggleControls: function() {
            this.passwordToggleControls.addClass('g-hidden');
        },
        toggleVisibility: function(event) {
            event.preventDefault();

            if (this.canSwitchInputType) {
                this.toggleVisibilityControl();
                var currentType = this.$('input').attr('type');
                var newType = currentType === 'password' ? 'text' : 'password';

                this.$('input')
                    .attr({type: newType})
                    .focus();
                this.emit('visibilityChange', newType);
            }
        },

        toggleVisibilityControl: function() {
            this.passwordToggleControls.toggleClass('g-hidden');
        },

        toggleHowTo: function(event) {
            event.preventDefault();
            $('.js-passwd_how_to_message').slideToggle(300);
        }
    });
})();
