(function(exports) {
    exports.acknowledgement = passport.block('phone-confirm-acknowledgement', 'control', {
        isRequired: false,
        needsServerValidation: false,

        validate: function() {
            this.emit('validation', true);
        },

        /**
         * @type PhoneModel
         */
        model: null,

        isEmpty: function() {
            return false;
        },

        /**
         * @param {PhoneModel} model
         */
        setModel: function(model) {
            this.model = model;
        },

        /**
         * @returns {PhoneModel}
         */
        getModel: function() {
            return this.model;
        },

        show: function() {
            var model = this.getModel();
            var method = 'getSanitized';

            if (!model) {
                throw new Error('Model should be set');
            }

            if (!model.isConfirmed()) {
                throw new Error('Model should be confirmed');
            }

            if (this.options && this.options.unmaskedAcknowledgement) {
                method = 'getSanitizedUnmasked';
            }

            this.setNumber(model[method]());
            this.$el.removeClass('g-hidden');
        },

        hide: function() {
            this.$el.addClass('g-hidden');
        },

        //        events: {
        //            "click .acknowledgement_restart": "restart",
        //            "keydown .acknowledgement_restart": "restart"
        //        },

        //        restart: function(event) {
        //            var isKeyboardSubmit = passport.util.isKeyboardSubmit(event);
        //
        //            if (!passport.util.isKeyboardEvent(event) || isKeyboardSubmit) {
        //                this.emit('restart');
        //            }
        //
        //            if (isKeyboardSubmit) {
        //                event.preventDefault();
        //            }
        //        },

        setNumber: function(number) {
            this.val(number);
        }
    });
    // eslint-disable-next-line no-undef
})(exports);
