(function(exports) {
    var blockId = 'phone-confirm-entry';
    var callValidationPath = 'phone-confirm-by-call-entry';
    var phoneEvents = passport.block('phone').events;

    var entry = passport.block('phone-confirm-entry', 'phone', {
        isRequired: true,
        needsServerValidation: true,
        controlSelector: '#phone_number',
        state: 'invalid',

        nbErrorParams: {
            how: {
                at: 'bottom',
                my: 'top'
            }
        },

        init: function() {
            var that = this;

            this.validationPath = blockId;

            this.inited.done(function() {
                setTimeout(function() {
                    if (that.options.mask) {
                        that.updateMask();
                    }

                    if (that.options.tryToCall) {
                        that.validationPath = callValidationPath;
                    }
                }, 1);
            });
        },

        updateMask: function() {
            $.fn.formatter.addInptType('+', /\+?/);

            var $ctrl = this.$ctrl;

            if (this.nbctrl && this.nbctrl.$control) {
                $ctrl = this.nbctrl.$control;
            }

            $ctrl.formatter(this.getFormatterOption());
        },

        getFormatterOption: function() {
            if (passport.language === 'tr') {
                return {
                    patterns: [
                        {'^\\+8': '{{+9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                        {'^8': '{{9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                        {'^\\+7': '{{+9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                        {'^7': '{{9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                        {'^\\+380': '{{+999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                        {'^380': '{{999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                        {'^\\+90': '{{+99}} ({{999}}) {{999}} {{9}} {{999}}{{999}}'},
                        {'^90': '{{99}} ({{999}}) {{999}} {{9}} {{999}}{{999}}'},
                        {'^\\+375': '{{+999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                        {'^\\375': '{{999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                        {'^\\+1': '{{+9}} ({{999}}) {{999}} {{9999}}{{999}}'},
                        {'^1': '{{9}} ({{999}}) {{999}} {{9999}}{{99999}}'},
                        {'^\\+': '{{+9999999999999999999}}'},
                        {'*': '{{99999999999999999999}}'}
                    ]
                };
            }

            return {
                patterns: [
                    {'^\\+8': '{{+9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                    {'^8': '{{9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                    {'^\\+7': '{{+9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                    {'^7': '{{9}} ({{999}}) {{999}} {{99}} {{99}}{{99999}}'},
                    {'^\\+380': '{{+999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                    {'^380': '{{999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                    {'^9': '{{999}} {{999}} {{99}} {{99}}{{99999}}'},
                    {'^\\+90': '{{+99}} ({{999}}) {{999}} {{9}} {{999}}{{999}}'},
                    {'^\\+375': '{{+999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                    {'^\\375': '{{999}} ({{99}}) {{999}} {{99}} {{99}}{{9999}}'},
                    {'^\\+1': '{{+9}} ({{999}}) {{999}} {{9999}}{{999}}'},
                    {'^1': '{{9}} ({{999}}) {{999}} {{9999}}{{99999}}'},
                    {'^\\+': '{{+9999999999999999999}}'},
                    {'*': '{{99999999999999999999}}'}
                ]
            };
        },

        /**
         * check has not default mask
         */
        hasMask: function() {
            return this.options.mask && !$.isEmptyObject(this.$ctrl.data('plugin_formatter').chars);
        },

        events: $.extend({}, phoneEvents, {
            'click .init-confirm': 'initConfirmation',
            'validation.phone-confirm-entry': 'validationHandle',
            'blur #phone_number': 'onBlur'
        }),

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        },

        /**
         * @param {PhoneModel} model
         */
        setModel: function(model) {
            this.model = model;
        },

        /**
         * @returns {PhoneModel}
         */
        getModel: function() {
            return this.model;
        },

        getValidationParams: function() {
            var params = {
                phone_number: this.val()
            };

            if (this.options && this.options.tryToCall) {
                params.validate_for_call = 'yes';
            }

            return params;
        },

        validate: function() {
            var deferred;

            if (!(this.options && this.options.noValidation)) {
                return this.parent.validate.apply(this, arguments);
            } else {
                deferred = new $.Deferred();
                deferred.resolve(true);
                this.emit('validation', true);
                return deferred;
            }
        },

        validationCallback: function(data, suppressError) {
            if (data.validation_errors) {
                this.validationResult(false, passport.validator.getErrorCode(data.validation_errors), suppressError);
            } else if (data.errors && data.errors.length) {
                this.validationResult(false, passport.validator.getErrorCodeFromEntity(data.errors), suppressError);
            } else {
                this.validationResult(data, null, suppressError);
            }

            return !data.validation_errors;
        },

        validationHandle: function(event, result) {
            this.isValidForCall = Boolean(result.valid_for_call);

            if (!this.options || !this.options.alternative) {
                return;
            }

            this.$('.init-confirm').toggleClass('_nb-action-button', result);
            this.state = result ? 'valid' : 'invalid';
        },

        initConfirmation: function(event) {
            var self = this;

            if (event) {
                event.preventDefault();
            }

            if (this.options.noValidation) {
                this.emit('phoneEntered', this.val(), this.isValidForCall);
            } else {
                this.validate().done(function() {
                    if (passport.validator.check(self)) {
                        self.emit('phoneEntered', self.val(), self.isValidForCall);
                    }
                });
            }
        },

        show: function() {
            this.$el.removeClass('g-hidden');
        },

        hide: function() {
            this.$el.addClass('g-hidden');
        },

        startSendingFeedback: function() {
            this.$('.init-confirm').addClass('g-hidden');

            passport.util.reattach(this.$('.init-confirm_spinner').removeClass('g-hidden'));

            this.disableControl();
        },

        stopSendingFeedback: function() {
            this.$('.init-confirm').removeClass('g-hidden');

            passport.util.reattach(this.$('.init-confirm_spinner').addClass('g-hidden'));

            this.enableControl();
        },

        disableControl: function() {
            this.$ctrl.prop('disabled', true).addClass('is-disabled');
        },

        enableControl: function() {
            this.$ctrl.prop('disabled', false).removeClass('is-disabled');
        }
    });

    passport.mixins.clickNextButtonOnEnterInsideInput(entry);
    exports.entry = entry;
    // eslint-disable-next-line no-undef
})(exports);
