var Field = require('pform/Field');
var PhoneField = require('../phone/phone.field');
var assert = require('assert');
var _ = require('lodash');

/**
 * @extends PhoneField
 */
var PhoneConfirmField = require('inherit')(PhoneField, {
    __constructor: function() {
        //Тырим все ошибки у телефона
        this.__base();
        var phoneErrors = this.getErrors();

        this._init('phone-confirm')
            .setName(new PhoneField().getName()) //Мимикрируем под телефон, перехватываем запросы
            .setLabel('%field_phone_number')
            .addError(new Field.Error('needsconfirmation', '%phone-confirm_errors_needs_confirmation'))
            .addError(new Field.Error('couldnotsend', '%phone-confirm_errors_couldnotsend'))
            .addError(new Field.Error('compromised', '%phone-confirm_errors_compromised'))
            .addError(new Field.Error('bound_and_confirmed', '%phone-confirm_errors_bound_and_confirmed'))
            .addError(new Field.Error('limitexceeded', '%phone-confirm_errors_confirmations_limitexceeded'))
            .addError(
                new Field.Error(
                    'limitexceeded_one_number',
                    '%phone-confirm_errors_confirmations_limitexceeded_one_number'
                )
            )
            .addError(new Field.Error('invalidsecurephone', '%phone-confirm_errors_invalidsecurephone'))
            .addError(new Field.Error('not_matched', '%phone-confirm_errors_invalidsecurephone'))
            .addError(new Field.Error('invalidcaptcha', '%phone-confirm_errors_invalidcaptcha'))
            .addError(new Field.Error('global_logout', '%common.errors.restore.global.logout'))
            .addError(new Field.Error('calls_limitexceeded', '%phone-confirm_errors_calls_limitexceeded'));

        phoneErrors.forEach(this.addError.bind(this));
        this.setCodeLabel('%phone-confirm_code_label');
    },

    _parseValue: function(formData) {
        // в случае повторного поста номер приходит в phone_number_confirmed
        var field = formData[this.getName()] || formData['phone_number_confirmed'];

        return this.normalizeValue(field);
    },

    isPresent: function(formData) {
        assert(_.isObjectLike(formData), 'Argument should be a posted form data');
        return this.getName() in formData || 'phone_number_confirmed' in formData;
    },

    setCodeLabel: function(labelLocKey) {
        this.setOption('codeLabel', labelLocKey);
    },

    compile: function(lang) {
        var compiled = this.__base.apply(this, arguments);

        compiled.phone = new PhoneField().compile(lang);
        compiled.options = require('lodash').extend(compiled.options, compiled.phone.options);
        compiled.codeLabel = require('putils').i18n(lang, this.getOption('codeLabel'));
        return compiled;
    }
});

module.exports = PhoneConfirmField;
