(function(exports) {
    var PhoneManager = function(PhoneModel, checkCaptha) {
        /**
         * Phone model to use
         *
         * @constructor
         * @private
         *
         * @type {PhoneModel}
         */
        this._Model = PhoneModel;

        /**
         * Mode for all the phone models
         * @type {PhoneModel.Mode}
         */
        this.mode = new PhoneModel.Mode();

        /**
         * Store for the created models
         * @type {Object<string, PhoneModel>}
         * @private
         */
        this._store = {};

        /**
         * The previously active model
         *
         * @type {PhoneModel}
         * @private
         */
        this._activeModel = null;

        /**
         * Флаг для blocks.js
         * Говорит нужно ли проверить валидность капчи перед отправкой смс
         *
         * @type {Boolean}
         */
        this.checkCaptha = checkCaptha;
    };

    PhoneManager.prototype = {
        /**
         * Returns a model for the given unsanitized number
         * Either creates a new model or returns an existing one
         *
         * @param {string} unsanitized
         * @returns PhoneModel
         */
        getModel: function(unsanitized) {
            if (!unsanitized || typeof unsanitized !== 'string') {
                throw new Error('Unsanitized number should be a string');
            }

            var model;

            if (unsanitized in this._store) {
                model = this._store[unsanitized];
                this._setTimeout(model);
                this._clearPreviousTimeout();
                this._activeModel = model;
                return model;
            }

            model = new this._Model(unsanitized);
            model.setMode(this.mode);
            model.setCheckCaptchaMode(this.checkCaptha);
            this._store[unsanitized] = model;
            return this.getModel(unsanitized);
        },

        /**
         * Returns the last model returned from this.getModel
         * @returns {PhoneModel}
         */
        getActive: function() {
            return this._activeModel;
        },

        /**
         * Sets the timeout for the model and returns it
         *
         * @param {PhoneModel}  model
         * @private
         */
        _setTimeout: function(model) {
            if (this._activeModel) {
                model.setTimeout(this._activeModel.getTimeout());
            }
        },

        /**
         * Clears the timeout on a previously active model
         * @private
         */
        _clearPreviousTimeout: function() {
            if (this._activeModel) {
                this._activeModel.clearTimeout();
            }
        }
    };

    exports.PhoneManager = PhoneManager;
    // eslint-disable-next-line no-undef
})(exports);
