var _ = require('lodash');
var Field = require('pform/Field');

/**
 * @extends Field
 */
var PhoneField = require('inherit')(Field, {
    __constructor: function() {
        this._init('phone')
            .setName('phone_number')
            .setLabel('%field_phone_number')
            .addError(new Field.Error('badphonenumber', '%phone_number_errors_badphonenumber'))
            .addError(new Field.Error('badphonenumberunmask', '%phone_number_errors_badphonenumberunmask'))
            .addError(new Field.Error('missingvalue', '%phone_number_errors_missingvalue'));
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    validate: function(formData, api) {
        return api.validatePhone({phone_number: this._parseValue(formData)}).then(function(result) {
            if (!result.body) {
                throw new Error('{ field: "password", body: <response> } expected');
            }

            return _.map(result.body.validation_errors || [], 'code');
        });
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    }
});

module.exports = PhoneField;
