(function() {
    var pin = passport.block('pin', 'control', {
        needsServerValidation: false,

        events: {
            'update.pin': 'onUpdate',
            'click .js-confirm-pin': 'checkPin'
        },

        getErrorCode: function(err) {
            return (err && err.split('.')[1]) || '';
        },

        validate: function(suppressError) {
            var val = this.val();

            if (val.length === 0) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (!/^\d+$/.test(val)) {
                this.validationResult(false, 'prohibitedsymbols', suppressError);
                return;
            }

            if (val.length < this.options.minlength) {
                this.validationResult(false, 'toshort', suppressError);
                return;
            }

            this.validationResult(true, null);
        },

        checkPin: function(event) {
            var self = this;

            if (event) {
                event.preventDefault();
            }

            passport.api
                .request(
                    this.id,
                    {
                        pin: this.val(),
                        track_id: passport.track_id
                    },
                    {
                        cache: false,
                        abortPrevious: true
                    }
                )
                .done(function(response) {
                    if (response.errors && response.errors.length) {
                        response.errors.forEach(function(err) {
                            self.$('.js-pin-checks-box').addClass('g-hidden');
                            var error = self.getErrorCode(err);

                            self.error(error);

                            if (error === 'not_matched' && response.pin_checks_left >= 0) {
                                if (response.pin_checks_left > 0) {
                                    self.$('.js-pin-checks').text(response.pin_checks_left);
                                    self.$('.js-pin-checks-box').removeClass('g-hidden');
                                } else {
                                    self.error('check_forbidden');
                                }
                            }
                        });
                    }

                    if (response.status === 'ok') {
                        self.$('.js-pin-checks-box').addClass('g-hidden');
                        self.emit('successCheck');
                        self.onSuccess();
                    }
                });
        },

        onUpdate: function() {
            this.toggleButtonState(passport.validator.check(this));
        },

        toggleButtonState: function(valid) {
            if (valid) {
                this.button.enable();
            } else {
                this.button.disable();
            }
        },

        onSuccess: function() {},

        init: function(options) {
            this.options = options;
            this.button = nb.block(this.$('.js-confirm-pin').get(0));
        }
    });

    passport.mixins.clickNextButtonOnEnterInsideInput(pin);
})();
