var nondigits = /\D/;
var Field = require('pform/Field');

/**
 * @extends Field
 */
var QuestionField = require('inherit')(Field, {
    __constructor: function() {
        this._init('question')
            .setName('hint_question_id')
            .setLabel('%field_hint_question_id_short')
            .addError(new Field.Error('missingvalue', '%hint_question_id_errors_missingvalue'));
    },

    isUserQuestion: function(formData) {
        return this.normalizeValue(formData[this.getName()]) === '99';
    },

    compile: function(lang, api) {
        var compiled = this.__base.apply(this, arguments);

        return api.getQuestions().then(function(response) {
            compiled.option = response.body.questions;
            return compiled;
        });
    },

    isEmpty: function(formData) {
        var value = this._parseValue(formData);
        var int = parseInt(value, 10);

        /**
         * Valid values are digits greater than 0
         * All other should be filtered out
         */
        return !value || int === 0 || nondigits.test(value);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    },

    onInvalid: function(errors, formData) {
        this.setValue(this._parseValue(formData));
        this.setErrorsActive(errors);
    }
});

module.exports = QuestionField;
