(function() {
    passport.block('restore-method', 'control', {
        needsServerValidation: false,

        init: function() {
            var validation_method = this.$el.find('#validation_method').val();

            this.switchState(validation_method === 'phone');
            this.checkQA();
        },

        events: {
            'click .set_question': 'setQuestion',
            'click .set_phone': 'setPhone',
            'update.question': 'checkQA',
            'update.answer': 'checkQA',
            'update.user-question': 'checkQA'
        },

        validate: function(suppressError) {
            this.validationResult(true, null, suppressError);
            return;
        },

        setPhone: function(event) {
            if (event) {
                event.preventDefault();
            }

            this.switchState(true);
        },
        setQuestion: function(event) {
            if (event) {
                event.preventDefault();
            }

            this.switchState(false);
        },
        switchState: function(isPhone) {
            var toPhone = Boolean(isPhone);
            var className = toPhone ? 'phone' : 'question';
            var validation_method = toPhone ? 'phone' : 'captcha';

            this.$el
                .removeClass('restore-method_state_phone')
                .removeClass('restore-method_state_question')
                .addClass('restore-method_state_' + className);

            this.$el.find('#validation_method').val(validation_method);

            passport.block('phone-confirm').inited.done(function(cntrl) {
                cntrl.toggleRequired(toPhone);
            });

            passport.block('question').inited.done(toggleCntrlState);
            passport.block('user-question').inited.done(toggleCntrlState);
            passport.block('answer').inited.done(toggleCntrlState);
            passport.block('captcha').inited.done(toggleCntrlState);

            function toggleCntrlState(cntrl) {
                if (cntrl.id === 'captcha') {
                    cntrl.val('');
                }
                cntrl.isRequired = !toPhone;
                cntrl.validate(true);
            }

            this.$el.find('.set_question').toggle(isPhone);
            this.$el.find('.set_phone').toggle(!isPhone);
        },
        checkQA: function() {
            var f = false;

            if ($('#hint_question_id select').val() !== '0' && $.trim($('#hint_answer').val())) {
                f = true;
                if ($('#hint_question_id select').val() === '99' && !$.trim($('#hint_question').val())) {
                    f = false;
                }
            }

            $('.restore-method_state_question .set_phone').toggle(!f);
        }
    });

    $(document).on('validation.phone-confirm', function(e, result) {
        if (result) {
            $('.p-control_name_restore-method .set_question').hide();
        }
    });
})();
