(function() {
    passport.block('additional-email', 'control', {
        needsServerValidation: false,
        isRequired: false,
        updateTimeout: 0,

        events: {
            'focusout .js-control__input': 'validate'
        },

        isDisabled: function() {
            return this.$('input').is(':disabled');
        },

        validate: function(suppressError) {
            if (this.isDisabled()) {
                this.validationResult(true, null, false);
                return;
            }

            var vals = this.val();

            for (var i = 0; i < vals.length; i++) {
                if (!passport.util.isEmail(vals[i])) {
                    this.validationResult(false, 'invalid', suppressError);
                    return;
                }
            }

            this.validationResult(true, null, false);
            return;
        }
    });
})();
