var Field = require('pform/Field');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('address')
            .setLabel('%field_address')
            .addError(new Field.Error('missingvalue', '%address_errors_missingvalue'));
    },

    _parseValue: function(formData) {
        return {
            prefilled: formData[`remember_${this.getName()}`] || ''
        };
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    isPresent: function(formData) {
        assert(_.isObjectLike(formData), 'Argument should be a posted form data');
        return `remember_${this.getName()}` in formData;
    }
});
