/* borschik:include:building/building.js */
/* borschik:include:country/country.js */
/* borschik:include:street/street.js */
/* borschik:include:suite/suite.js */
/* borschik:include:city/city.js */

(function() {
    passport.block('address', {
        updateTimeout: 0,
        isRequired: false,
        subBlocks: ['building', 'country', 'street', 'city'],

        events: {
            'change .js-control__field_address input': 'toggleRequired'
        },

        isPresent: function(field) {
            return Boolean(this.$('input[name="' + field + '"]').val());
        },

        toggleSubBlocksState: function(isRequired) {
            this.subBlocks.forEach(function(item) {
                var block = passport.block(item);

                block.isRequired = isRequired;
            });
        },

        toggleRequired: function() {
            var self = this;
            var hasValue = false;

            this.subBlocks.forEach(function(block) {
                if (self.isPresent(block)) {
                    hasValue = true;
                }
            });

            this.toggleSubBlocksState(hasValue);
        }
    });
})();
