var Field = require('pform/Field');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('feedback-email')
            .setLabel('%field_feedback_email')
            .addError(new Field.Error('missingvalue', '%feedback_email_errors_missingvalue'))
            .addError(new Field.Error('from_same_account', '%feedback_email_errors_from_same_account'))
            .addError(new Field.Error('invalid', '%email_errors_invalid'));
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    }
});
