var Field = require('pform/Field');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('last-auth')
            .setLabel('%semiauto.lastauth')
            .addError(new Field.Error('missingvalue', '%last_passwords_errors_missingdate'))
            .addError(new Field.Error('invalid', '%last_passwords_errors_invaliddate'))
            .addError(
                new Field.Error('earlierthenregistrationdate', '%last_passwords_errors_earlierthenregistrationdate')
            )
            .addError(new Field.Error('tooearly', '%last_passwords_errors_tooearly'));
    },

    _dateFields: {
        day: 'last-auth_day',
        year: 'last-auth_year',
        month: 'last-auth_month'
    },

    _parseValue: function(formData) {
        var data = {};
        var that = this;

        Object.keys(this._dateFields).forEach(function(key) {
            data[key] = that.normalizeValue(formData[that._dateFields[key]]);
        });

        data.isEmpty = formData[`remember_${this.getName()}`] ? true : false;

        return data;
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    isPresent: function(formData) {
        assert(_.isObjectLike(formData), 'Argument should be a posted form data');
        var that = this;
        var keys = [`remember_${this.getName()}`];

        Object.keys(this._dateFields).forEach(function(key) {
            keys.push(that._dateFields[key]);
        });

        return _.find(keys, function(key) {
            return key in formData;
        });
    },

    isEmpty: function(formData) {
        return !(this._parseValue(formData).year && this._parseValue(formData).month && this._parseValue(formData).day);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    }
});
