var Field = require('pform/Field');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('last-passwords')
            .setLabel('%field_last_passwords')
            .addError(new Field.Error('missingvalue', '%last_passwords_errors_missingpass'))
            .addError(new Field.Error('prohibitedsymbols', '%password_errors_prohibitedsymbols'))
            .addError(new Field.Error('duplicate', '%semiauto.last-passwords.errors.duplicate'));
    },

    setValue: function() {
        return this;
    },

    isEmpty: function(formData) {
        if (this._values.options && this._values.options.multiplyFields) {
            return !this._parseValue(formData)['values'].length;
        } else {
            return !this._parseValue(formData);
        }
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    }
});
