(function() {
    passport.block('phones', 'control', {
        needsServerValidation: false,
        isRequired: false,
        updateTimeout: 0,

        events: {
            'focusout input[type="text"]': 'validate'
        },

        isDisabled: function() {
            return this.$('input').is(':disabled');
        },

        // eslint-disable-next-line no-useless-escape
        normalizeValueRegExp: /[()-\+\s]/g,
        nondigitRegExp: /\D/,

        validate: function(suppressError) {
            if (this.isDisabled()) {
                this.validationResult(true, null, false);
                return;
            }

            var vals = this.val();

            for (var i = 0; i < vals.length; i++) {
                var normalizeValue = vals[i].replace(this.normalizeValueRegExp, '');

                if (normalizeValue && this.nondigitRegExp.test(normalizeValue)) {
                    this.validationResult(false, 'invalid', suppressError);
                    return;
                }

                if (normalizeValue && normalizeValue.length < 10) {
                    this.validationResult(false, 'invalid', suppressError);
                    return;
                }
            }

            this.validationResult(true, null, false);
            return;
        }
    });
})();
