var Field = require('pform/Field');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('questions')
            .setLabel('%field_questions')
            .addError(new Field.Error('empty', '%questions_errors_empty'))
            .addError(new Field.Error('long', '%semiauto.questions.errors.long'));

        this._questions = [];
    },

    _parseValue: function(formData) {
        return {
            text: formData[this.getName()],
            id: formData[`${this.getName()}_id`]
        };
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    setQuestions: function(data) {
        this._questions = data || [];
    },

    compile: function(lang) {
        var compiled = this.__base.call(this, lang);

        compiled.questions = this._questions;

        return compiled;
    },

    isPresent: function(formData) {
        assert(_.isObjectLike(formData), 'Argument should be a posted form data');
        return _.find([this.getName(), `${this.getName()}_text`], function(key) {
            return key in formData;
        });
    }
});
