(function() {
    passport.block('questions', 'control', {
        updateTimeout: 0,
        isRequired: false,
        needsServerValidation: false,

        events: {
            'change .js-questions': 'setQuestionText',
            'change .js-questions-text': 'toggleAnswerRequired'
        },

        val: function() {
            return {
                id: this.$ctrl.val(),
                text: this.$('.js-questions-text').val()
            };
        },

        text: function() {
            return this.val().id === '-1' ? '' : this.$('option:selected').text();
        },

        toggleAnswerRequired: function() {
            passport.block('answers').isRequired = this.val().text.trim() !== '';
        },

        init: function() {
            var that = this;
            var select = nb.block(document.getElementById(this.id));

            if (select) {
                select.on('nb-changed', function() {
                    that.setQuestionText();
                });

                this.inited.done(this.setQuestionText.bind(this));
            }
        },

        setQuestionText: function() {
            this.$('.js-questions-text')
                .val(this.text())
                .trigger('change');
        }
    });
})();
