(function() {
    var registrationCity = passport.block('registration-city', 'control', {
        updateTimeout: 50,
        isRequired: true,
        needsServerValidation: false,

        parseData: function(data) {
            if (!data.length) {
                this.clear();
                this.hideSuggest();
                return;
            }

            var that = this;
            var result = '';

            data.forEach(function(item) {
                if (item.name && item.id) {
                    result += [
                        '<span class="b-suggest_item js-suggest_item" data-name="',
                        item.name,
                        '" data-code="',
                        item.id,
                        '">',
                        item.name
                    ].join('');
                    if (item.countryName && !that.countryId && !that.countryName) {
                        result += [' (', item.countryName, ')'].join('');
                    }
                    result += '</span>';
                }
            });

            this.suggest.html(result);

            if (!result.length) {
                this.hideSuggest();
                return;
            }

            this.showSuggest();
        },

        getSuggestData: function() {
            var value = this.val();

            if (!value) {
                this.clear();
                this.hideSuggest();
                return;
            }

            this.countryId = $('input[name="registration-country_id"]').val() || '';
            this.countryName = $('input[name="registration-country"]').val() || '';
            var query = passport.util.normalize(value.toLowerCase());
            var that = this;

            $.post(
                '/suggest/city',
                {
                    str: query,
                    language: passport.language || 'ru',
                    country_id: this.countryId,
                    country_name: this.countryName
                },
                function(res) {
                    if (res) {
                        that.parseData(res);
                    }
                }
            );
        }
    });

    passport.mixins.suggest(registrationCity);
})();
