var Field = require('pform/Field');
var assert = require('assert');
var _ = require('lodash');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('registration-country')
            .setLabel('%field_registration_country')
            .addError(new Field.Error('missingvalue', '%registration_country_errors_missingvalue'))
            .addError(new Field.Error('invalid', '%registration_country_errors_invalid'));
    },

    _parseValue: function(formData) {
        return {
            name: this.normalizeValue(formData[this.getName()]),
            id: this.normalizeValue(formData[`${this.getName()}_id`])
        };
    },

    setValue: function(value) {
        assert(_.isObjectLike(value), 'Value should be a plain object');
        this._values.value = value;
        return this;
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    isEmpty: function(formData) {
        return !this._parseValue(formData).name;
    }
});
