(function() {
    var registrationCountry = passport.block('registration-country', 'control', {
        updateTimeout: 50,
        isRequired: true,
        needsServerValidation: false,
        storage: {},
        storageParsed: {},

        parseData: function(key) {
            if (!key) {
                this.clear();
                this.hideSuggest();
                return;
            }

            var result = this.storageParsed[key] || '';
            var data = this.storage[key] || '';

            if (!result && data.length) {
                data.forEach(function(item) {
                    if (item.name && item.id) {
                        result += [
                            '<span class="b-suggest_item js-suggest_item" data-name="',
                            item.name,
                            '" data-code="',
                            item.id,
                            '">',
                            item.name,
                            '</span>'
                        ].join('');
                    }
                });

                this.storageParsed[key] = result;
            }

            this.suggest.html(result);

            if (!result.length) {
                this.hideSuggest();
                return;
            }

            this.showSuggest();
        },

        getSuggestData: function() {
            var value = this.val();

            if (!value) {
                this.clear();
                this.hideSuggest();
                return;
            }

            var query = passport.util.normalize(value.toLowerCase());
            var that = this;

            if (this.storage[query] || query === '') {
                this.parseData(query);
            } else {
                $.post(
                    '/suggest/country',
                    {
                        str: query,
                        language: passport.language || 'ru'
                    },
                    function(res) {
                        if (res) {
                            that.storage[query] = res;
                            that.parseData(query);
                        }
                    }
                );
            }
        }
    });

    passport.mixins.suggest(registrationCountry);
})();
